<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt"
  version="1.0">

<xsl:template name="PropCell">
  <xsl:param name="PropName"/>
  <xsl:param name="CheckNull"/>
  <xsl:param name="CheckFSName"/>
  <xsl:param name="WordWrap" select="0"/>

  <xsl:variable name="FSName" select="PropertyBag/Property[@name='PROPID_HDM_INTERNALFSNAME']"/>
  <xsl:variable 
    name="HasFSProps" 
    select="$FSName != 'UNKNOWN' and 
      	$FSName != 'INVALID' and 
      	$FSName != 'FREE' and 
      	$FSName != 'NOTFORMATTED' and 
      	$FSName != 'LSWAP' and
      	$FSName != 'LSWAP1' and
      	$FSName != 'BACKUPCAPSULE'"
    />

  <xsl:if test="PropertyBag/Property[@name=$PropName] and 
    (not(boolean($CheckNull)) or number(PropertyBag/Property[@name=$PropName]) != 0) and
    (not(boolean($CheckFSName)) or boolean($HasFSProps))">
    <tr>
      <td align="right">
        <nobr><b><xsl:value-of select="ImplicitCommands/Property[@propname=$PropName]"/></b></nobr>
      </td>
      <xsl:choose>
        <xsl:when test="ImplicitCommands/Property[@propname=$PropName]/@action">
          <td width="100%">
            <a>
              <xsl:attribute name="href">
                <xsl:value-of select="ImplicitCommands/Property[@propname=$PropName]/@action"/>
              </xsl:attribute>
              <nobr><xsl:value-of select="PropertyBag/Property[@name=$PropName]"/></nobr>
            </a>
          </td>
        </xsl:when>      
        <xsl:otherwise>
          <td width="100%">
            <xsl:choose>
              <xsl:when test="number($WordWrap) != 0"><xsl:value-of select="PropertyBag/Property[@name=$PropName]"/></xsl:when>
              <xsl:otherwise><nobr><xsl:value-of select="PropertyBag/Property[@name=$PropName]"/></nobr></xsl:otherwise>
            </xsl:choose>
          </td>
        </xsl:otherwise>
      </xsl:choose>
    </tr>
  </xsl:if>
</xsl:template>

<xsl:template name="CommandGroup">
  <xsl:param name="GroupNode"/>

  <td width="50%" valign="top">
    <h3><nobr><xsl:value-of select="$GroupNode/Text"/></nobr></h3><br/>
          
    <table border="0" >
      <xsl:for-each select="$GroupNode/Command">
        <tr>
          <td valign="middle">
            <xsl:if test="Image">
              <img width="16" height="16"><xsl:attribute name="src"><xsl:value-of select="Image"/></xsl:attribute></img>
            </xsl:if>
          </td>
          <td align="left" valign="middle" width="100%">
            <nobr><a>
              <xsl:attribute name="href"><xsl:value-of select="Action"/></xsl:attribute>
              <xsl:value-of select="Text"/>
            </a>
            </nobr>
          </td>
        </tr>
      </xsl:for-each>
    </table>
  </td>
</xsl:template>

<xsl:template name="CommandTable">
  <!-- Command hyperlinks -->
  <table border="0">
    <xsl:choose>
    	<xsl:when test="count(Commands/CmdGroup) != 0">
        <xsl:for-each select="Commands/CmdGroup">
          <xsl:if test="(position() mod 3) = 1">
            <tr>

	            <xsl:call-template name="CommandGroup">
                <xsl:with-param name="GroupNode" select="."/>
							</xsl:call-template>

	            <xsl:call-template name="CommandGroup">
                <xsl:with-param name="GroupNode" select="following-sibling::CmdGroup[position()=1]"/>
							</xsl:call-template>

	            <xsl:call-template name="CommandGroup">
                <xsl:with-param name="GroupNode" select="following-sibling::CmdGroup[position()=2]"/>
							</xsl:call-template>

              <td width="100%"> </td>
            </tr>
                      
            <tr><td colspan="3"><img src="hline_gray"/></td></tr>
          

          </xsl:if>
        </xsl:for-each>
			</xsl:when>
  
  		<xsl:otherwise>
        <xsl:for-each select="Commands/Command">
          <tr>
            <td valign="center">
              <xsl:choose>
                <xsl:when test="Image">
                  <img><xsl:attribute name="src"><xsl:value-of select="Image"/></xsl:attribute></img>
                </xsl:when>

				  			<xsl:otherwise>
              		<img src="generic_action"/>
				  			</xsl:otherwise>
              </xsl:choose>
            </td>
            
            <td width="100%">
              <a>
                <xsl:attribute name="href"><xsl:value-of select="Action"/></xsl:attribute>
                <b><xsl:value-of select="Text"/></b>
              </a>
              <br/>
              <xsl:value-of select="TipText" disable-output-escaping="yes"/>
            </td>
          </tr>
        </xsl:for-each>
  		</xsl:otherwise>
    </xsl:choose>
  </table>
</xsl:template>

</xsl:stylesheet>
